package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Date;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue("2")
public class ResearchStudy extends Activity { 

	public static ResearchStudy findById(final int activityId) {
		return DartObjectFactory.getInstance().getResearchStudyDAO().findById(activityId);
	}
	
	public static ResearchStudy findByShortName(final String name) throws ValidationException {
		ValidationHelper.required("Research Study Sort Name", name);
		ValidationHelper.validateSize("Research Study Sort Name", name, 1, 1024);
		
		return DartObjectFactory.getInstance().getResearchStudyDAO().findByShortName(name);
	}
	
	protected ResearchStudy() {}
	
	public static ResearchStudy create(final String name, final Date startDate, final Date endDate, final String officialName, final String createdBy) throws ValidationException {
		ResearchStudy study = new ResearchStudy();
		
		ValidationHelper.required("Created By", createdBy);
		ValidationHelper.validateSize("Created By", createdBy, 1, 32);
		
		study.setCreatedOn(new Date());
		study.setCreatedBy(createdBy);
		
		study.modify(name, startDate, endDate, officialName, createdBy);
		
		DartObjectFactory.getInstance().getResearchStudyDAO().save(study);
		
		return study;
	}
	
	public void modify(final String name, final Date startDate, final Date endDate, final String officialName, final String updatedBy) throws ValidationException {
		validateModify(name, startDate, endDate, officialName, updatedBy);
		
		this.name = name;
		this.startDate = startDate;
		this.endDate = endDate;
		this.officialName = officialName;
		this.updatedBy = updatedBy;
		this.updatedOn = new Date();
	}
	
	private void validateModify(final String name, final Date startDate, final Date endDate, final String officialName, final String updatedBy) throws ValidationException {

		//
		// business rules require that name not be required...
		//ValidationHelper.required("Name", name);
		ValidationHelper.validateSize("Name", name, 0, 1024);
		ValidationHelper.required("Official Name", officialName);
		ValidationHelper.validateSize("Official Name", officialName, 0, 1024);
		ValidationHelper.required("Updated By", updatedBy);
		ValidationHelper.validateSize("Updated By", updatedBy, 0, 32);
		
		if (startDate != null) {
			if (CAL_1900.getTime().after(startDate)) {
				throw new ValidationException("Start date must be after Jan 1, 1900");
			}
		}
		
		if (endDate != null) {
			if (CAL_1900.getTime().after(endDate)) {
				throw new ValidationException("End date must be after Jan 1, 1900");
			}
		}

		if (startDate != null && endDate != null) {
			if (startDate.after(endDate)) {
				throw new ValidationException("Start date must be before end date.");
			}
		}
	}

	@Override
	public int hashCode() {
		return this.id;
	}
	
	// necessary to use (List<ResearchStudy>).contains()
	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof ResearchStudy) == false) {
			return false;
		}
		
		ResearchStudy rs2 = (ResearchStudy)obj;
		return rs2.getId() == this.getId();
	}
}
